import re, string,os
from PyQt4.QtCore import QString

try :
    import cPickle as pickle
except:
    import pickle

class PototoDict():
    def __init__(self):
        self.db_pt = {}
        self.db_fr = {}
        self.changed = False

    def qstr2str(self, mot):
        if type(mot) is QString:
            return str(mot.toUtf8()).decode('utf-8')
        else:
            return mot

    def addWord(self,fr,pt):
        fr = self.qstr2str(fr)
        pt = self.qstr2str(pt)
        if fr not in self.db_fr and pt not in self.db_pt:
            self.db_fr[fr] = pt
            self.db_pt[pt] = fr
            self.changed = True
            return True
        return False

    def replaceWord(self,fr,pt):
        fr = self.qstr2str(fr)
        pt = self.qstr2str(pt)
        prev_fr = self.translateFrom(pt,'PT')
        prev_pt = self.translateFrom(fr,'FR')

        self.removeWord(fr,'FR')
        self.removeWord(pt,'PT')
        if prev_fr is not None:
            self.removeWord(prev_fr,'FR')
        if prev_pt is not None:
            self.removeWord(prev_pt,'PT')
        self.changed = True
        return self.addWord(fr,pt)

    def removeWord(self,mot,langue):
        mot = self.qstr2str(mot)
        if(langue == 'PT'):
            if mot in self.db_pt:
                del self.db_pt[mot]
                return True
        if(langue == 'FR'):
            if mot in self.db_fr:
                del self.db_fr[mot]
                return True
        self.changed = True
        return False

    def translateFrom(self,mot,langue):
        mot = self.qstr2str(mot)
        if(langue == 'PT'):
            if mot in self.db_pt:
                return self.db_pt[mot]
            else:
                return None

        if(langue == 'FR'):
            if mot in self.db_fr:
                return self.db_fr[mot]
            else:
                return None

    def getWords(self,langue):
        if langue == 'PT':
            return self.db_pt.keys()
        elif langue == 'FR':
            return self.db_fr.keys()
        else:
            return []
    
    
    def translateSentenceFrom(self,phrase,langue):
        phrase = self.qstr2str(phrase)
        print 'Translating "%s"'%(phrase)
        # split sentence into tokens
        tokens = re.findall(r"\w+\'\w+|\w+|[^\w]",phrase,re.UNICODE)
        number_tokens = re.findall(r"[-+]?\d*\.\d+|\d+",phrase,re.UNICODE)
        print tokens
        result = ''
        punctuation = set(string.punctuation+' ')
        punctuation.update(number_tokens)
        for mot in tokens:
            if mot not in punctuation:
                mot_tr = self.translateFrom(mot,langue)
                if mot_tr is not None:
                    result += mot_tr
                else:
                    result += '*'*len(mot)
            else:
                result += mot

        print result
        return result
    
    def loadFromDisk(self):
        print 'Loading current db from disk'
        if (os.path.exists('db_fr_pt.p')):
            output = open('db_fr_pt.p','r')
            self.db_fr = pickle.load(output)
            self.db_pt = pickle.load(output)
            output.close()
            return True
        else:
            return False


    def writeToDisk(self):
        if self.changed:
            print 'Writing current db to disk'
            output = open('db_fr_pt.p','w')
            pickle.dump(self.db_fr,output)
            pickle.dump(self.db_pt,output)
            output.close()
            self.changed = False

    def writeBackup(self):
        output = open('db_fr_pt.p.bak','w')
        pickle.dump(self.db_fr,output)
        pickle.dump(self.db_pt,output)
        output.close()
