# -*- coding: utf8 -*-
import sys,os
from PyQt4 import QtGui, QtCore
from pototo_dict import PototoDict

class PopotoMainWindow(QtGui.QWidget):
    def __init__ (self, parent=None):
        QtGui.QMainWindow.__init__(self,parent)
        # get screen size
        self.screen_dims = QtGui.QDesktopWidget().screenGeometry()
        self.setGeometry(self.screen_dims.width()*2/3-100,100,
                         self.screen_dims.width()/3, 
                         self.screen_dims.height()/1.5)
        self.setWindowTitle('PIZZA NE FOOTBALL FANTAISIE')
        self.labelFont = QtGui.QFont("Monospace", 10)
        self.setFont(self.labelFont)
        self.pototo_dict = PototoDict()
        self.cmpl_fr = QtGui.QCompleter()
        self.cmpl_pt = QtGui.QCompleter()
        self.strm_fr = QtGui.QStringListModel()
        self.strm_pt = QtGui.QStringListModel()
        self.cmpl_fr.setModel(self.strm_fr)
        self.cmpl_pt.setModel(self.strm_pt)
        if self.pototo_dict.loadFromDisk():
            self.strm_fr.setStringList(self.pototo_dict.getWords('FR'))
            self.strm_pt.setStringList(self.pototo_dict.getWords('PT'))
        self.save_timer = QtCore.QTimer(self)
        self.save_timer.setInterval(5000)
        self.save_timer.start()
        self.save_timer.timeout.connect(self.save)

        self.initUI()

    def initUI(self):
        # frame for new word
        frame_n = self.initNouveau()

        # frame for translation
        frame_t = self.initTraduction()

        # frame for modifying
        frame_m = self.initModifier()

        # quit button
        qbtn = QtGui.QPushButton('bye!',self)
        qbtn.clicked.connect(QtCore.QCoreApplication.instance().quit)
        qbtn.resize(qbtn.sizeHint())

        vsplitter = QtGui.QSplitter(QtCore.Qt.Vertical)
        vsplitter.addWidget(frame_n)
        vsplitter.addWidget(frame_t)
        vsplitter.addWidget(frame_m)
        vsplitter.addWidget(qbtn)
        
        vbox = QtGui.QVBoxLayout()
        vbox.addWidget(vsplitter)
        self.setLayout(vbox)
        self.show()

    def initNouveau(self):
        lbl1 = QtGui.QLabel('fr',self)
        txt1 = QtGui.QLineEdit(self)
        txt1.setObjectName('fr_n')
        lbl3 = QtGui.QLabel('=',self)
        txt2 = QtGui.QLineEdit(self)
        txt2.setObjectName('pt_n')
        lbl2 = QtGui.QLabel('pt',self)
        sbtn = QtGui.QPushButton('enregister',self)
        sbtn.setObjectName('save')
        sbtn.clicked.connect(self.buttonClicked)


        hbox_n = QtGui.QHBoxLayout()
        hbox_n.addStretch(1)
        hbox_n.addWidget(lbl1)
        hbox_n.addWidget(txt1)
        hbox_n.addWidget(lbl3)
        hbox_n.addWidget(lbl2)
        hbox_n.addWidget(txt2)
        hbox_n.addWidget(sbtn)
        hbox_n.addStretch(1)

        frame_n = QtGui.QFrame(self)
        frame_n.setLayout(hbox_n)

        return frame_n

    def initTraduction(self):
        lbl1 = QtGui.QLabel('français'.decode('utf-8'),self)
        lbl1.setAlignment(QtCore.Qt.AlignRight | QtCore.Qt.AlignVCenter)
        txt1 = QtGui.QLineEdit(self)
        txt1.setObjectName('fr_t')
        lbl2 = QtGui.QLabel('pototeau',self)
        lbl2.setAlignment(QtCore.Qt.AlignRight | QtCore.Qt.AlignVCenter)
        txt2 = QtGui.QLineEdit(self)
        txt2.setObjectName('pt_t')

        txt1.textEdited.connect(self.translationUpdate)
        txt2.textEdited.connect(self.translationUpdate)

        hbox1 = QtGui.QHBoxLayout()
        hbox1.addWidget(lbl1)
        hbox1.addWidget(txt1)

        hbox2 = QtGui.QHBoxLayout()
        hbox2.addWidget(lbl2)
        hbox2.addWidget(txt2)

        vbox = QtGui.QVBoxLayout()
        vbox.addStretch(1)
        vbox.addLayout(hbox1)
        vbox.addLayout(hbox2)
        vbox.addStretch(1)

        frame_t = QtGui.QFrame(self)
        frame_t.setLayout(vbox)

        return frame_t

    def initModifier(self):
        lbl1 = QtGui.QLabel('français'.decode('utf-8'),self)
        lbl1.setAlignment(QtCore.Qt.AlignRight | QtCore.Qt.AlignVCenter)
        txt1 = QtGui.QLineEdit(self)
        txt1.setObjectName('fr_m')
        lbl2 = QtGui.QLabel('pototeau',self)
        lbl2.setAlignment(QtCore.Qt.AlignRight | QtCore.Qt.AlignVCenter)
        txt2 = QtGui.QLineEdit(self)
        txt2.setObjectName('pt_m')
        gbtn = QtGui.QPushButton('go',self)
        gbtn.setObjectName('mod')
        gbtn.clicked.connect(self.buttonClicked)

        mpic = QtGui.QPixmap('imgs/magnifyingglass.png')
        lbl3 = QtGui.QLabel()
        lbl4 = QtGui.QLabel()
        lbl3.setPixmap(mpic)
        lbl4.setPixmap(mpic)
        txt1.setCompleter(self.cmpl_fr)
        txt2.setCompleter(self.cmpl_pt)

        hbox1 = QtGui.QHBoxLayout()
        hbox1.addWidget(lbl1)
        hbox1.addWidget(lbl3)
        hbox1.addWidget(txt1)
        frame1 = QtGui.QFrame(self)
        frame1.setLayout(hbox1)

        hbox2 = QtGui.QHBoxLayout()
        hbox2.addWidget(lbl2)
        hbox2.addWidget(lbl4)
        hbox2.addWidget(txt2)
        frame2 = QtGui.QFrame(self)
        frame2.setLayout(hbox2)

        vbox = QtGui.QVBoxLayout()
        vbox.addStretch(1)
        vbox.addWidget(frame1)
        vbox.addWidget(frame2)
        vbox.addStretch(1)

        hbox = QtGui.QHBoxLayout()
        hbox.addLayout(vbox)
        hbox.addWidget(gbtn)

        frame_m = QtGui.QFrame(self)
        frame_m.setLayout(hbox)

        return frame_m

    def translationUpdate(self):
        sender = self.sender()
        print sender.objectName()

        if sender.objectName() == 'fr_t':
            phrase_fr = sender.text()
            phrase_pt = self.pototo_dict.translateSentenceFrom(phrase_fr,'FR')
            self.findChild(QtGui.QLineEdit, 'pt_t').setText(phrase_pt)

        elif sender.objectName() == 'pt_t':
            phrase_pt = sender.text()
            phrase_fr = self.pototo_dict.translateSentenceFrom(phrase_pt,'PT')
            self.findChild(QtGui.QLineEdit, 'fr_t').setText(phrase_fr)

    
    def buttonClicked(self):
        sender = self.sender()
        print sender.objectName()
        if sender.objectName() == 'save':
            mot_fr = self.findChild(QtGui.QLineEdit, 'fr_n').text()
            mot_pt = self.findChild(QtGui.QLineEdit, 'pt_n').text()

            if self.pototo_dict.addWord(mot_fr,mot_pt):
                print 'Added [%s,%s] to dictionary'%(mot_fr,mot_pt)
                self.findChild(QtGui.QLineEdit, 'fr_n').setText('')
                self.findChild(QtGui.QLineEdit, 'pt_n').setText('')

                self.strm_fr.setStringList(self.pototo_dict.getWords('FR'))
                self.strm_pt.setStringList(self.pototo_dict.getWords('PT'))
            else:
                prev_pt = self.pototo_dict.translateFrom(mot_fr,'FR')
                prev_fr = self.pototo_dict.translateFrom(mot_pt,'PT')
                if prev_pt is not None:
                    qinfo = QtGui.QMessageBox.warning(self,"Oops","'%s' == '%s'"%(mot_fr,prev_pt))
                if prev_fr is not None:
                    qinfo = QtGui.QMessageBox.warning(self,"Oops","'%s' == '%s'"%(prev_fr,mot_pt))
                print 'Failed to add [%s,%s] to dictionary :('%(mot_fr,mot_pt)

        elif sender.objectName() == "mod":
            mot_fr = self.findChild(QtGui.QLineEdit, 'fr_m').text()
            mot_pt = self.findChild(QtGui.QLineEdit, 'pt_m').text()
            
            # check if word exists
            prev_pt = self.pototo_dict.translateFrom(mot_fr,'FR')
            prev_fr = self.pototo_dict.translateFrom(mot_pt,'PT')

            if prev_fr is None and prev_pt is None:
                qinfo = QtGui.QMessageBox.warning(self,"Oops","'%s' ou '%s' ne sont pas dans le dictionnaire"%(mot_fr,mot_pt))
                return
            elif prev_fr is None:
                prev_fr = mot_fr
            elif prev_pt is None:
                prev_pt = mot_pt
            if mot_pt == '' and mot_fr != '':
                self.pototo_dict.removeWord(mot_fr,'FR')
                self.pototo_dict.removeWord(prev_pt,'PT')
                return
            elif mot_pt != '' and mot_fr == '':
                self.pototo_dict.removeWord(prev_fr,'FR')
                self.pototo_dict.removeWord(mot_pt,'PT')
                return

            if self.pototo_dict.replaceWord(mot_fr,mot_pt):
               print 'Replaced [%s,%s] with [%s,%s] in dictionary'%(prev_fr,prev_pt,mot_fr,mot_pt)
               self.strm_fr.setStringList(self.pototo_dict.getWords('FR'))
               self.strm_pt.setStringList(self.pototo_dict.getWords('PT'))
    
    def save(self):
        self.pototo_dict.writeToDisk()

    def closeEvent(self, event):
        self.save_timer.stop()
        self.pototo_dict.writeToDisk()
        self.pototo_dict.writeBackup()

            
def main():
    popoto_app = QtGui.QApplication(sys.argv)
    
    main_window = PopotoMainWindow()
    sys.exit(popoto_app.exec_())

if __name__=='__main__':
    os.chdir(os.path.dirname(os.path.realpath(__file__)))
    main()
